<?php include_once("./includes/prohibir.php"); ?>
<?php include_once("../includes/datos.php"); ?>
<?php include_once("./includes/config.php"); ?>
<?php
if (!empty($_GET['id']) && is_numeric($_GET['id'])) {
    $id = $_GET['id'];
    $institucion = $_SESSION['id'];
    $result = $mysqli->prepare("SELECT * from animales WHERE id = ? and animales.institucion = ?");
    $result->bind_param("ii", $id, $institucion);
    $result->execute();
    $result = $result->get_result();
    if ($result->num_rows == 1) {
        $row = $result->fetch_assoc();
    } else {
        header("Location: ./home.php");
    }
} else {
    header("Location: ./home.php");
}

?>

<?php include_once("./includes/arriba.php"); ?>

<!-- Begin Page Content -->
<div class="container-fluid">

    <!-- Page Heading -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Editar Perro</h1>
    </div>

    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <form method="POST" action="./includes/editar_perro.php" enctype="multipart/form-data">
                <input type="hidden" name="especie" value="1">
                <input type="hidden" name="id" value="<?php echo $row['id']; ?>">
                <input type="hidden" name="institucion" value="<?php echo $_SESSION['id']; ?>">
                <div class="form-group">
                    <input type="text" value="<?php echo $row['nombre']; ?>" class="form-control form-control-user" name="nombre" required maxlength="50" placeholder="Nombre del Perro">
                </div>
                <div class="form-group">
                    <input type="date" text" value="<?php echo $row['fecha_nacimiento']; ?>" class="form-control form-control-user" name="fecha_nacimiento" required placeholder="Fecha de Nacimiento">
                </div>
                <div class="form-group">
                    <label>La Fecha es estiamada?: <input type="checkbox" <?php if ($row['estimado'] == 1) {
                                                                                echo "checked";
                                                                            } ?> class="form-control form-control-user" name="estimado" value="1"></label>
                </div>
                <div class="form-group">
                    <input type="text" value="<?php echo $row['codigo']; ?>" class="form-control form-control-user" name="codigo" maxlength="100" placeholder="Código">
                </div>
                <div class="form-group">
                    <input type="text" value="<?php echo $row['youtube']; ?>" class="form-control form-control-user" name="youtube" maxlength="50" placeholder="Código youtube">
                </div>
                <div class="form-group">
                    <textarea class="form-control form-control-user" placeholder="Descripción... caracter, etc," name="descripcion"><?php echo $row['descripcion']; ?></textarea>
                </div>
                <div class="form-group">
                    <textarea class="form-control form-control-user" placeholder="Estado de Salud. Describa el estado general, vacunas, desparasitación, chip.." name="salud"><?php echo $row['salud']; ?></textarea>
                </div>
                <div class="form-group">
                    <textarea class="form-control form-control-user" placeholder="Política particular de adopción de este perro" name="politica"><?php echo $row['politica']; ?></textarea>
                </div>
                <div class="form-group">
                    <select name="raza" required class="form-control form-control-user">
                        <option value="">Seleccione una raza</option>
                        <option value="1">MESTIZA</option>
                        <?php
                        $query = "SELECT id, raza FROM razas WHERE especie = 1 order by raza asc";
                        $result = $mysqli->query($query);
                        while ($row_raza = $result->fetch_assoc()) {
                        ?>
                            <option <?php if ($row['raza'] == $row_raza['id']) {
                                        echo "selected";
                                    } ?> value="<?php echo $row_raza['id']; ?>"><?php echo $row_raza['raza']; ?></option>
                        <?php } ?>
                    </select>
                </div>
                <div class="form-group">
                    <select name="size" required class="form-control form-control-user">
                        <option value="">Tamaño</option>
                        <?php
                        $query = "SELECT id, size FROM sizes WHERE especie = 1 order by size asc";
                        $result = $mysqli->query($query);
                        while ($row_size = $result->fetch_assoc()) {
                        ?>
                            <option <?php if ($row['size'] == $row_size['id']) {
                                        echo "selected";
                                    } ?> value="<?php echo $row_size['id']; ?>"><?php echo $row_size['size']; ?></option>
                        <?php } ?>
                    </select>
                </div>
                <div class="form-group">
                    <fieldset>
                        <legend>Sexo:</legend>
                        <div class="partir">
                            <label>Hembra:<input <?php if ($row['sexo'] == 0) {
                                                        echo "checked";
                                                    } ?> type="radio" class="form-control form-control-user" name="sexo" value="0"></label>
                        </div>
                        <div class="partir">
                            <label>Macho:<input <?php if ($row['sexo'] == 1) {
                                                    echo "checked";
                                                } ?> type="radio" class="form-control form-control-user" name="sexo" value="1" placeholder="Macho"></label>
                        </div>
                    </fieldset>
                </div>
                <div class="form-group">
                    <fieldset>
                        <legend>Temperamento:</legend>
                        <?php

                        $query = "select temperamento from temperamentos_animales where animal = " . $id;
                        $result = $mysqli->query($query);
                        $temperamentos = [];
                        while ($row_tem_animal = $result->fetch_assoc()) {
                            $temperamentos[$row_tem_animal['temperamento']] = true;
                        }

                        $query = "SELECT id, temperamento FROM temperamentos WHERE especie = 1 order by temperamento asc";
                        $result = $mysqli->query($query);
                        while ($row_tem = $result->fetch_assoc()) {
                        ?>
                            <label class="respirar"><?php echo $row_tem['temperamento']; ?><input <?php if (!empty($temperamentos[$row_tem['id']]) && $temperamentos[$row_tem['id']] == true) {
                                                                                                        echo "checked";
                                                                                                    } ?> type="checkbox" class="form-control form-control-user" name="temperamento[]" value="<?php echo $row_tem['id']; ?>"></label>
                        <?php } ?>
                    </fieldset>
                </div>
                <div class="form-group">
                    <input type="file" class="form-control form-control-user" name="fotos[]" placeholder="Fotos" multiple accept="image/jpg,image/jpeg">
                </div>
                <div class="form-group">
                    <input type="submit" class="btn btn-facebook btn-user btn-block" value="Enviar">
                </div>
            </form>
        </div>
        <br>
        <div class="container-fluid">
            <div class="row">
                <?php
                $query = "select * from fotos where animal = " . $id;
                $result = $mysqli->query($query);
                while ($row_foto = $result->fetch_assoc()) {
                ?>
                    <div class="col-xl-6 col-lg-6" id="foto_<?php echo $row_foto['id']; ?>">
                        <div class="card shadow mb-4">
                            <!-- Card Header - Dropdown -->
                            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                                <h6 class="m-0 font-weight-bold text-primary">Foto</h6>
                                <div class="dropdown no-arrow">
                                    <a class="dropdown-toggle" href="#" role="button" id="dropdownMenuLink" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                        <i class="fas fa-ellipsis-v fa-sm fa-fw text-gray-400"></i>
                                    </a>
                                    <div class="dropdown-menu dropdown-menu-right shadow animated--fade-in" aria-labelledby="dropdownMenuLink">
                                        <div class="dropdown-header">Opciones:</div>
                                        <a class="dropdown-item" onclick="borrar_fotos_perros(<?php echo $row_foto['id']; ?>)">Borrar</a>
                                    </div>
                                </div>
                            </div>
                            <!-- Card Body -->
                            <div class="card-body">
                                <img class="ancho_img" src="../fotos/<?php echo $row_foto['id']; ?>_p.jpg">
                            </div>
                        </div>
                    </div>

                <?php
                }
                ?>
            </div>
        </div>
    </div>


</div>
<!-- /.container-fluid -->

</div>
<!-- End of Main Content -->

<?php include_once("includes/abajo.php"); ?>