<?php
include_once('./includes/config.php');
?>
<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $titulo; ?></title>
    <link rel="stylesheet" href="./includes/css.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css" integrity="sha512-iBBXm8fW90+nuLcSKlbmrPcLa0OT92xO1BIsZ+ywDWZCvqsWgccV3gFoRBv0z+8dLJgyAHIhR35VZc2oM/gI1w==" crossorigin="anonymous" />
    <script src="https://code.jquery.com/jquery-3.6.0.js" integrity="sha256-H+K7U5CnXl1h5ywQfKtSj8PCmoN9aaq30gDh27Xc0jk=" crossorigin="anonymous"></script>
    <script src="./includes/js.js"></script>
</head>

<body>

    <header>
        <i class="fas fa-bars" id="botonmenu"></i>
        <h1><?php echo $titulo; ?></h1>
        <div>
            <input type="search" name="Buscar" placeholder="Buscar..." id="buscador">
        </div>
    </header>

    <nav id="menu">
        <ul>
            <?php
            //for($contador = 0; $contador < count($categorias) ; $contador++){
            $contador = 0;
            while ($contador < count($categorias)) {
                $clase = "";
                if ($contador == $cat) {
                    $clase = ' class="seleccionado"';
                }
                echo '<li' . $clase . '><a href="index.php?cat=' . $contador . '"><i class="fas fa-angle-right"></i> ' . $categorias[$contador++] . '</a></li>';
            }
            ?>
        </ul>
    </nav>
    <main>
        <h1><?php echo $titulo; ?></h1>
        <ul id="productos">
            <?php
            if($cat >= 0){
                for($contador = 0; $contador < count($productos[$cat]); $contador++){
                    pintar_producto($cat, $contador, $productos, $precios);
                }
            } else {
                echo "<li><p>No ha seleccionado ninguna Categoría</p></li>";
            }
            ?>

        </ul>
        <nav id="paginacion" class="respirar">
            <ul>
                <li><a class="boton" href="#"><i class="fas fa-backward"></i></a></li>
                <li><a class="boton" href="#"><i class="fas fa-forward"></i></a></li>
            </ul>
        </nav>
    </main>
    <footer>
        <nav>
            <ul>
                <li><a href="index.html"><i class="fas fa-cookie-bite"></i> Cookies</a></li>
                <li><a href="index.html"><i class="fas fa-balance-scale"></i> Legal</a></li>
                <li><a href="index.html"><i class="fas fa-user-secret"></i> Protección de Datos</a></li>
                <li><a href="index.html"><i class="fas fa-envelope"></i> Contacto</a></li>
                <li><a href="index.html"><i class="fas fa-home"></i> HOME</a></li>
            </ul>
        </nav>
    </footer>
</body>

</html>