<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Lista de Tareas</title>

    <script src="https://unpkg.com/ionicons@5.4.0/dist/ionicons.js"></script>
</head>

<body>

    <header>
        <h1>Mis Tareas</h1>
        <form action="./includes/nueva_tarea.php" method="post">
            <input type="text" name="tarea" id="" required>
            <button type="submit">Enviar</button>
        </form>
    </header>
    <main>
        <table>
        <caption>SERIALIZADO</caption>
            <thead>
                <tr>
                    <th>#</th>
                    <th>Tarea</th>
                    <th>
                        <ion-icon name="trash-outline"></ion-icon>
                    </th>
                </tr>
            </thead>
            <tbody>
                <?php
                if (!empty($_COOKIE['tareas'])) {
                    $tareas = unserialize($_COOKIE['tareas']);
                    foreach ($tareas as $key => $value) {
                ?>
                        <tr>
                            <td><?php echo $key ?></td>
                            <td><?php echo $value ?></td>
                            <td>
                                <a href="./includes/borrar.php?key=<?php echo $key; ?>"><ion-icon name="trash-outline"></ion-icon></a>
                            </td>
                        </tr>
                <?php
                    }
                } else {
                }
                ?>
            </tbody>
        </table>

        <table>
        <caption>JSON</caption>
            <thead>
                <tr>
                    <th>#</th>
                    <th>Tarea</th>
                    <th>
                        <ion-icon name="trash-outline"></ion-icon>
                    </th>
                </tr>
            </thead>
            <tbody>
                <?php
                if (!empty($_COOKIE['tareas'])) {
                    $tareas = json_decode($_COOKIE['tareas_json']);
                    foreach ($tareas as $key => $value) {
                ?>
                        <tr>
                            <td><?php echo $key ?></td>
                            <td><?php echo $value ?></td>
                            <td>
                                <a href="./includes/borrar.php?key=<?php echo $key; ?>"><ion-icon name="trash-outline"></ion-icon></a>
                            </td>
                        </tr>
                <?php
                    }
                } else {
                }
                ?>
            </tbody>
        </table>
    </main>
</body>

</html>