<?php include_once('./includes/categorias.php'); ?>
<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Mi Lista de la Compra</title>
    <script src="https://code.jquery.com/jquery-3.6.0.js" integrity="sha256-H+K7U5CnXl1h5ywQfKtSj8PCmoN9aaq30gDh27Xc0jk=" crossorigin="anonymous"></script>
    <link rel="stylesheet" href="https://pro.fontawesome.com/releases/v5.10.0/css/all.css" integrity="sha384-AYmEC3Yw5cVb3ZcuHtOA93w35dYTsvhLPVnYs9eStHfGJvOvKxVfELGroGkvsg+p" crossorigin="anonymous" />
    <script src="//cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>
    <link rel="stylesheet" href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css">
    
    <link rel="stylesheet" href="./includes/css.css">

    <script>
        $(document).ready(function() {
            $('#myTable').DataTable({
                "paging": false,
                "ordering": true,
                "info": false,
                "responsive": true,
                "language": {
                    "search": "Buscar"
                }
            });
        });
    </script>

</head>

<body>
    <header>
        <h1>Lista de la Comprar</h1>
        <form action="./includes/funciones.php?operacion=nuevo" method="post">
            <input type="text" required name="producto" placeholder="Nuevo Producto" id="">
            <br>
            <select name="categoria" id="" required>
                <option value="">Seleccione...</option>
                <?php
                    foreach ($categorias as $key => $value) {
                        echo '<option value="'.$key.'">'.$value.'</option>';                    }
                ?>
            </select>
            <button type="submit"><i class="fas fa-cart-plus"></i></button>
        </form>
    </header>
    <main>
        <table id="myTable" class="display">
            <thead>
                <tr>
                    <th>Producto</th>
                    <th>Categoría</th>
                    <th><i class="fas fa-cart-arrow-down"></i></th>
                    <th><i class="fas fa-trash-alt"></i></th>
                </tr>
            </thead>
            <tbody>
                <?php
                if (!empty($_COOKIE['productos'])) {
                    $productos = unserialize($_COOKIE['productos']);
                    foreach ($productos as $key => $value) {
                        if ($value[1] == 1) {
                            echo '<td><strong>' . $value[0] . '</strong></td>';
                        } else {
                            echo '<td><strike>' . $value[0] . '</strike></td>';
                        }
                        echo '<td>' . $categorias[$value[2]] . '</td>';
                        if ($value[1] == 1) {
                            echo '<td><a href="./includes/funciones.php?id=' . $key . '&o=0&operacion=editar">Comprar</a></td>';
                        } else {
                            echo '<td><a href="./includes/funciones.php?id=' . $key . '&o=1&operacion=editar">Usar</i></a></td>';
                        }
                        echo '<td><a href="./includes/funciones.php?id=' . $key . '&operacion=borrar"><i class="fas fa-trash-alt"></i></a></td></tr>';
                    }
                }
                ?>
            </tbody>
        </table>
    </main>

</body>

</html>