<?php

$css_table = "<style>   
table.tablaphp {
    width: 100%;
    border-collapse: collapse;
}


table.tablaphp tr:nth-of-type(odd) {
    background: #eee;
}

table.tablaphp th {
    background: #333;
    color: white;
    font-weight: bold;
}

table.tablaphp td,
table.tablaphp th {
    padding: 6px;
    border: 1px solid #ccc;
    text-align: left;
}
</style>";



function importe(float $importe, float $iva = 21.00): array
{
    $neto =  $importe / (($iva / 100) + 1);
    $array = [$neto, ($importe - $neto)];
    return $array;
}


function dibujarTabla(array $array, $titulos = false, $usarcss = false)
{
    if($usarcss == true){
        echo $GLOBALS['css_table'];
    }
    $desde = 0;
    echo "<table";
    if($usarcss == true){
        echo " class='tablaphp'";
    }
    echo ">";
    if ($titulos == true) {
        echo "<thead><tr>";
        for ($i = 0; $i < count($array[0]); $i++) {
            echo "<th>" . $array[0][$i] . "</th>";
        }
        echo "</tr></thead>";
        $desde = 1;
    }
    echo "<tbody>";
    for ($f = $desde; $f < count($array); $f++) {
        echo "<tr>";
        for ($c = 0; $c < count($array[$f]); $c++) {
            echo "<td>" . $array[$f][$c] . "</td>";
        }
        echo "</tr>";
    }
    echo "</tbody></table>";
}


function triangulo($lado)
{
    echo "<br>";
    for ($f = 1; $f <= $lado; $f++) {
        for ($v = 0; $v < ($lado - $f); $v++) {
            echo "&nbsp";
        }
        for ($v = 0; $v < $f; $v++) {
            echo ".&nbsp";
        }
        echo "<br>";
    }
}


function ordenarArray($array)
{
    for ($i = 0; $i < count($array) - 1; $i++) {
        if ($array[$i] > $array[$i + 1]) {
            $intercambio = $array[$i];
            $array[$i] = $array[$i + 1];
            $array[$i + 1] = $intercambio;
            $i = -1;
        }
    }
    return $array;
}

function cartonBingo(): array
{
    $todoslosnumeros = [];
    $contador = 0;
    $numeros = [];
    $numerosp = [];

    for ($f = 0; $f <= 8; $f++) {
        for ($c = 0; $c <= 9; $c++) {
            $todoslosnumeros[$f][$c] = $contador++;
        }
    }


    for ($f = 0; $f < 3; $f++) {
        for ($c = 0; $c < 9; $c++) {
            $key = rand(0, (9 - $f));
            $numeros[] = $todoslosnumeros[$c][$key];
            $numerosp[$f][$c] = -1;
            $todoslosnumeros[$c][$key] = $todoslosnumeros[$c][9 - $f];
            $todoslosnumeros[$c][9 - $f] = $numeros[$c];
        }
    }

    $numeros = ordenarArray($numeros);


    $contador = 0;
    for ($i = 0; $i < 26; $i += 3) {
        $numerosp[0][$contador] = $numeros[$i];
        $numerosp[1][$contador] = $numeros[$i + 1];
        $numerosp[2][$contador++] = $numeros[$i + 2];
    }

    for ($f = 0; $f < 2; $f++) {
        $utilizados = 0;
        while ($utilizados < 4) {
            $key = rand(0, 8);
            if (is_numeric($numerosp[$f][$key]) && $numerosp[$f][$key] != -1) {
                $numerosp[$f][$key] = "<img src='./bombilla/bingo.png'>";
                $utilizados++;
            }
        }
    }

    $utilizados = 0;
    for ($c = 0; $c < 9; $c++) {
        if (is_numeric($numerosp[0][$c]) && ($numerosp[0][$c] >= 0) && ($numerosp[1][$c] >= 0) && is_numeric($numerosp[1][$c])) {
            $numerosp[2][$c] = "<img src='./bombilla/bingo.png'>";
            $utilizados++;
        }
    }

    while ($utilizados < 4) {
        $key = rand(0, 8);
        if ((($numerosp[0][$key] != -1) || ($numerosp[1][$key] != -1)) && $numerosp[2][$key] != -1) {
            $numerosp[2][$key] = "<img src='./bombilla/bingo.png'>";
            $utilizados++;
        }
    }
    return $numerosp;
}

function crearMenu(array $menu, int $padre = 0): string{
    static $lista = "";
    if($padre == 0){
        $lista = "";
    }
    $lista .= "<ul>";
    foreach ($menu as $key => $value) {
        if ($value[1] == $padre) {
            $lista .= "<li>";
            $lista .= $value[0];
            crearMenu($menu, $key);
            $lista .= "</li>";
        }
    }
    $lista .= "</ul>";
    return $lista;
}
