<?php
class Tabla
{
    private $titulos;
    private $datos;
    private $clase;
    private $tieneTitulos;

    public function __construct($datos, $titulos = "", $clase = "table", $tieneTitulos = false, $pintar = true)
    {
        $this->titulos = $titulos;
        $this->datos = $datos;
        $this->clase = $clase;
        $this->tieneTitulos = $tieneTitulos;
        if($pintar == true){
            $this->pintar();
        }
    }

    private function thead()
    {
        echo "<thead><tr>";
        foreach ($this->titulos as $key => $value) {
            echo "<th>{$value}</th>";
        }
        echo "</tr></thead>";
    }

    private function tbody()
    {
        echo "<tbody>";

        while ($row = $this->datos->fetch_row()) {
            echo "<tr>";
            foreach ($row as $key => $dato) {
                echo "<td>{$dato}</td>";
            }
            echo "</tr>";
        }
        echo "</tbody>";
    }

    public function pintar()
    {
        echo "<table class='{$this->clase}'>";
        if ($this->tieneTitulos == true) {
            $this->thead();
        }
        $this->tbody();
        echo "</table>";
    }
}

class Select{
    private $result;
    public $select;
    private $name;
    private $id;
    private $descripcion;

    public function __construct($result, $name, $id, $descripcion, $select = "")
    {
        $this->result = $result;
        $this->name = $name;
        $this->id = $id;
        $this->descripcion = $descripcion;
        $this->select = $select;
        $this->pintar();
    }

    public function pintar()
    {
        $this->result->data_seek(0);
        echo '<select name="'.$this->name.'" id="'.$this->id.'"><option value="">'.$this->descripcion.'</option>';    
            while($row = $this->result->fetch_row()){
                $seleccionado = "";
                if($row[0] == $this->select){
                    $seleccionado = "selected";
                }
                echo '<option '.$seleccionado.' value="'.$row[0].'">'.$row[1].'</option>';
            }
        echo '</select>';
    }
}
