<?php include_once('./includes/categorias.php'); ?>
<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Mi Lista de la Compra</title>
    <script src="https://code.jquery.com/jquery-3.6.0.js" crossorigin="anonymous"></script>
    <link rel="stylesheet" href="https://pro.fontawesome.com/releases/v5.10.0/css/all.css" integrity="sha384-AYmEC3Yw5cVb3ZcuHtOA93w35dYTsvhLPVnYs9eStHfGJvOvKxVfELGroGkvsg+p" crossorigin="anonymous" />
    <script src="//cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>
    <link rel="stylesheet" href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css">
    
    <script src="includes/js.js"></script>

    <link rel="stylesheet" href="./includes/css.css">

</head>

<body>
    <header>
        <h1>Lista de la Comprar</h1>
        <form action="javascript:nuevo();" method="post">
            <input type="text" required name="producto" placeholder="Nuevo Producto" id="producto">
            <br>
            <select name="categoria" required id="categoria">
                <?php
                    foreach ($categorias as $key => $value) {
                        echo '<option value="'.$key.'">'.$value.'</option>';                    }
                ?>
            </select>
            <button type="submit"><i class="fas fa-cart-plus"></i></button>
        </form>
    </header>
    <main>
        <table id="myTable" class="display greyGridTable">
            <thead>
                <tr>
                    <th>Producto</th>
                    <th>Categoría</th>
                    <th><i class="fas fa-cart-arrow-down"></i></th>
                    <th><i class="fas fa-trash-alt"></i></th>
                </tr>
            </thead>
            <tbody>
                <?php
                if (!empty($_COOKIE['productos'])) {
                    $productos = unserialize($_COOKIE['productos']);
                    foreach ($productos as $key => $value) {
                        echo "<tr id='fila_".$key."'>";
                        if ($value[1] == 1) {
                            echo '<td id="producto_'.$key.'" class="sincomprar">' . $value[0] . '</td>';
                        } else {
                            echo '<td id="producto_'.$key.'" class="comprado">' . $value[0] . '</td>';
                        }
                        echo '<td>' . $categorias[$value[2]] . '</td><td id="editar_'.$key.'">';
                        if ($value[1] == 1) {
                            echo '<i class="fas fa-shopping-basket" onclick="editar('.$key.',0,\'editar\')"></i>';
                            /* echo '<td><a href="./includes/funciones.php?id=' . $key . '&o=0&operacion=editar">Comprar</a></td>'; */
                        } else {
                            echo '<i class="fas fa-recycle" onclick="editar('.$key.',1,\'editar\')"></i>';
                            /* echo '<td><a href="./includes/funciones.php?id=' . $key . '&o=1&operacion=editar">Usar</i></a></td>'; */
                        }
                        echo '</td><td><i class="fas fa-trash-alt" onclick="borrar('.$key.')"></i></td></tr>';
                    }
                }
                ?>
            </tbody>
        </table>
        <div id="pintar">
            Cargando...<br><i class="fas fa-cog fa-spin"></i>
        </div>
    </main>

</body>

</html>