function leerProductos(fn = nohagona) {
    products = [];
    $.each(datos['productos'], function(key, val) {
        products.push([key, val[0], val[1], val[2]]);
    });
    datos['productos'] = products;
    fn();
}


function pintarDatos() {
    var listado = $("#listadolistacompra");
    listado.html("");
    listados = [];
    contador = 0;
    if (datos['productos'].length > 0) {

        let produc = datos['productos'].sort(porcategorias);

        function porcategorias(a, b) {
            if (a[3] === b[3]) {
                return 0;
            } else {
                return (a[3] < b[3]) ? -1 : 1;
            }
        }
        //console.log(produc);
        $.each(produc, function(key, value) {
            var checked = 'checked';
            if (value[2] == 1) {
                checked = '';
            }
            //console.log(categoriaProductosFiltro, estadoProductosFiltro);
            if ((categoriaProductosFiltro == -1 || value[3] == categoriaProductosFiltro) && (estadoProductosFiltro == value[2])) {
                listados[key] = '<ons-list-item class="color' + value[2] + '" id="producto_' + key + '"><div class="left"><ons-checkbox ' + checked + ' onchange="estadoProducto(' + key + ')" input-id="check-' + key + '" on></ons-checkbox></div><div class="center"><span class="list-item__title">' + value[1] + '</span><span class="list-item__subtitle">' + datos['categorias'][value[3]] + '</span></div><div class="right" onclick="BorrarProducto(' + key + ')"><ons-icon icon="fa-trash-alt"></ons-icon></div></ons-list-item>';
                contador++;
            }
        });
        if (contador == 0) {
            listados[0] = '<ons-list-item><div class="left"><ons-icon icon="fa-exclamation-circle" style="color:red" class="list-item__icon"></ons-icon></div><div class="center"> No hay productos...</div></ons-list-item>';
        }
        if (listados.length > 0) {
            $.each(listados, function(key, val) {
                listado.append(val);
            });
        }
    } else {
        $.each(listados, function(key, val) {
            listado.append(val);
        });
    }
}


function pintarProductosNuevos() {
    listados = [];
    listados[0] = '<ons-list-item><div class="left"><ons-icon icon="fa-exclamation-circle" style="color:red" class="list-item__icon"></ons-icon></div><div class="center"> No productos en la lista</div></ons-list-item>';
    if (datos['productos'].length > 0) {
        var ultimos = datos['productos'].reverse();
        ultimos = ultimos.slice(0, 10);
        $.each(ultimos, function(key, value) {
            listados[key] = '<ons-list-item><div class="center"><span class="list-item__title">' + value[1] + '</span><span class="list-item__subtitle">' + datos['categorias'][value[3]] + '</span></div><div class="right"><ons-icon icon="fa-trash-alt"></ons-icon></div></ons-list-item>';
        });
        var listado = $("#listadolistacompranuevo");
        listado.html("");
        if (listados.length > 0) {
            $.each(listados, function(key, val) {
                listado.append(val);
            });
        }
    }
}

function NuevoProducto() {
    $("#iconobotonguardar").html('<ons-icon spin icon="fa-spinner"></ons-icon>');
    let producto = $("#pageListaCompraNuevo #producto").val();
    if (producto != "") {
        $.ajax({
                method: "POST",
                url: "./includes/nuevo.php",
                data: { "producto": producto, "categoria": $("#categorias").val() }
            })
            .done(function(msg) {
                $("#iconobotonguardar").html('<ons-icon icon="fa-save"></ons-icon>');
                if (msg >= 0) {
                    $("#listadolistacompranuevo").prepend('<ons-list-item><div class="center"><span class="list-item__title">' + $("#producto").val() + '</span><span class="list-item__subtitle">' + categorias[$("#categorias").val()] + '</span></div><div class="right"><ons-icon icon="fa-trash-alt"></ons-icon></div></ons-list-item>');
                    $("#pageListaCompraNuevo #producto").val("");
                    //$("#form_nuevo_producto").trigger('reset');
                    ons.notification.toast('<ons-icon style="color: green;" icon="fa-check"></ons-icon> Producto guardado correctamente<button onclick="mitoast.hide()">Cerrar</button>', {
                        id: "mitoast",
                        timeout: 4000
                    });
                } else {
                    ons.notification.toast('<ons-icon style="color: red;" icon="fa-exclamation-triangle"></ons-icon> ERROR, algo ha fallado <button onclick="mitoast.hide()">Cerrar</button>', {
                        id: "mitoast",
                        timeout: 4000
                    });
                }

            });
    }
}


function BorrarProducto(key) {
    if (key >= 0) {
        llave = datos['productos'][key][0];
        $.ajax({
                method: "POST",
                url: "./includes/borrarproducto.php",
                data: { "key": llave }
            })
            .done(function(msg) {
                if (msg >= 1) {
                    datos['productos'].splice(key, 1);
                    $("#producto_" + key).hide('slow', function() {
                        pintarDatos();
                    });
                    ons.notification.toast('<ons-icon style="color: green;" icon="fa-check"></ons-icon> Producto Eliminado correctamente<button onclick="mitoast.hide()">Cerrar</button>', {
                        id: "mitoast",
                        timeout: 1000
                    });
                } else {
                    ons.notification.toast('<ons-icon style="color: red;" icon="fa-exclamation-triangle"></ons-icon> ERROR, algo ha fallado <button onclick="mitoast.hide()">Cerrar</button>', {
                        id: "mitoast",
                        timeout: 4000
                    });
                }

            });
    }
}

function estadoProducto(key) {
    if (key >= 0) {
        llave = datos['productos'][key][0];
        var estado = 0;
        if ($('#check-' + key).prop('checked') == false) {
            estado = 1;
        }

        $.ajax({
                method: "POST",
                url: "./includes/estadoproducto.php",
                data: { "key": llave, "estado": estado }
            })
            .done(function(msg) {
                if (msg == 1) {
                    $("#producto_" + key).removeClass().addClass("color" + estado);
                    ons.notification.toast('<ons-icon style="color: green;" icon="fa-check"></ons-icon> Operación guarda correctamente<button onclick="mitoast.hide()">Cerrar</button>', {
                        id: "mitoast",
                        timeout: 1000
                    });
                } else {
                    ons.notification.toast('<ons-icon style="color: red;" icon="fa-exclamation-triangle"></ons-icon> ERROR, algo ha fallado <button onclick="mitoast.hide()">Cerrar</button>', {
                        id: "mitoast",
                        timeout: 4000
                    });
                }

            });
    }
}