function pintarTareas() {
    var listado = $("#pageTareas #listadotareas");
    listado.html("");
    listados = [];
    contador = 0;
    if (datos['listatareas'].length > 0) {
        $.each(datos['listatareas'], function(key, value) {
            var checked = 'checked';
            if (value['estado'] == 1) {
                checked = '';
            }
            listados[key] = '<ons-list-item id="tarea_' + value['id'] + '" data-key="' + key + '"><div class="left"><ons-icon style="color: ' + value['color'] + ';" icon="fa-circle"></ons-icon></div><div data-key="' + key + '" class="center"><span class="list-item__title">' + value['tarea'] + '</span></div><div class="right" onclick="BorrarTarea(' + value['id'] + ')"><ons-icon icon="fa-trash-alt"></ons-icon></div></ons-list-item>';
            contador++;

        });
        if (contador == 0) {
            listados[0] = '<ons-list-item><div class="left"><ons-icon icon="fa-exclamation-circle" style="color:red" class="list-item__icon"></ons-icon></div><div class="center"> No hay Tareas...</div></ons-list-item>';
        }
        if (listados.length > 0) {
            $.each(listados, function(key, val) {
                listado.append(val);
            });
        }
    } else {
        $.each(listados, function(key, val) {
            listado.append(val);
        });
    }

    $("#pageTareas #listadotareas .center").click(function(e) {
        key_p = $(this).data("key");
        id_p = datos['listatareas'][key_p]['id'];
        myNavigator.pushPage('editartarea.html')
    });
}

function NuevaTarea() {
    $("#iconobotonguardar").html('<ons-icon spin icon="fa-spinner"></ons-icon>');
    let tarea = $("#pageTareaNueva #tarea").val();
    if (tarea != "") {
        $.ajax({
                method: "POST",
                url: "./includes/?tabla=tareas",
                dataType: 'json',
                data: JSON.stringify({ "tarea": tarea, "importancia": $("#importancia").val() })
            })
            .done(function(msg) {
                $("#iconobotonguardar").html('<ons-icon icon="fa-save"></ons-icon>');
                if (msg['id'] >= 0) {
                    haynuevos = true;
                    $("#listadonuevos").prepend('<ons-list-item><div class="center"><span class="list-item__title">' + $("#tarea").val() + '</span><span class="list-item__subtitle">' + $("#importancia option:selected").html() + '</span></div></ons-list-item>');
                    $("#pageTareaNueva #tarea").val("");
                    ons.notification.toast('<ons-icon style="color: green;" icon="fa-check"></ons-icon> Tarea Guardada Correctamente<button onclick="mitoast.hide()">Cerrar</button>', {
                        id: "mitoast",
                        timeout: 1000
                    });
                } else {
                    ons.notification.toast('<ons-icon style="color: red;" icon="fa-exclamation-triangle"></ons-icon> ERROR, algo ha fallado <button onclick="mitoast.hide()">Cerrar</button>', {
                        id: "mitoast",
                        timeout: 2000
                    });
                }
            });
    }
}

function BorrarTarea(id) {
    if (id >= 0) {
        $.ajax({
            method: "DELETE",
            url: "./includes/?tabla=tareas",
            dataType: 'json',
            data: JSON.stringify({ "id": id }),
            complete: function(xhr, textStatus) {
                if (xhr.status == 200) {
                    let key = $("#tarea_" + id).data("key");
                    datos['listatareas'].splice(key, 1);
                    $("#tarea_" + id).hide('slow', function() {
                        pintarTareas();
                    });
                    ons.notification.toast('<ons-icon style="color: green;" icon="fa-check"></ons-icon> Tarea Eliminada Correctamente<button onclick="mitoast.hide()">Cerrar</button>', {
                        id: "mitoast",
                        timeout: 1000
                    });
                } else {
                    ons.notification.toast('<ons-icon style="color: red;" icon="fa-exclamation-triangle"></ons-icon> ERROR, algo ha fallado <button onclick="mitoast.hide()">Cerrar</button>', {
                        id: "mitoast",
                        timeout: 3000
                    });
                }

            }
        })
    }
}

function EditarTarea() {
    if (id_p >= 0) {
        $.ajax({
            method: "PUT",
            url: "./includes/?tabla=tareas&id=" + id_p,
            dataType: 'json',
            data: JSON.stringify({ "tarea": $("#tarea").val(), "importancia": $("#importancia").val() }),
            complete: function(xhr, textStatus) {
                if (xhr.status == 200) {
                    datos['listatareas'][key_p]['tarea'] = $("#tarea").val();
                    datos['listatareas'][key_p]['importancia'] = $("#importancia").val();
                    datos['listatareas'][key_p]['imp'] = $("#importancia option:selected").html();
                    var importancia = datos['importanciasOrdenado'].filter(function(el) {
                        return el.id == $("#importancia").val();
                    });
                    datos['listatareas'][key_p]['color'] = importancia[0]['color'];
                    pintarTareas();
                    ons.notification.toast('<ons-icon style="color: green;" icon="fa-check"></ons-icon> Tarea Editada Correctamente<button onclick="mitoast.hide()">Cerrar</button>', {
                        id: "mitoast",
                        timeout: 1000
                    });
                } else {
                    ons.notification.toast('<ons-icon style="color: red;" icon="fa-exclamation-triangle"></ons-icon> ERROR, algo ha fallado <button onclick="mitoast.hide()">Cerrar</button>', {
                        id: "mitoast",
                        timeout: 3000
                    });
                }

            }
        })
    }
}