//variables generales
let id_p;
let key_p;
let haynuevos = false; //así vemos cuando hay que actualizar los listados
var datos = {
    'listacompra': [],
    'categoriasProductosOrdenado': [],
    'listatareas': [],
    'importanciasOrdenado': [],
    'listaagenda': []
};


let categorias = [];
var categoriaProductosFiltro = -1;
var estadoProductosFiltro = 1;


//MENU
window.fn = {};
window.fn.open = function open() {
    var menu = document.getElementById('menu');
    menu.open();
};

window.fn.load = function(page) {
    var content = document.getElementById('myNavigator');
    var menu = document.getElementById('menu');
    content.resetToPage(page);
    menu.close();
};


//$(document).ready(function() {
ons.ready(function() {
    leer();
});


document.addEventListener('init', function(event) {
    if (event.target.matches('#pageListaCompra')) {
        pintarDatos();
        var actualizar = function() {
            leerkey('listacompra', pintarDatos);
        }
        actualizarListas(actualizar);
    }

    if (event.target.matches('#pageTareas')) {
        pintarTareas();
        var actualizar = function() {
            leerkey('listatareas', pintarTareas);
        }
        actualizarListas(actualizar);
    }

    if (event.target.matches('#pageAgenda')) {
        pintarAgenda();
        var actualizar = function() {
            leerkey('listaagenda', pintarAgenda);
        }
        actualizarListas(actualizar);
    }

    if (event.target.matches('#pageListaCompraNuevo')) {
        $.each(datos['categoriasProductosOrdenado'], function(key, value) {
            var o = new Option(value['categoria'], value['id']);
            $("#categorias").append(o);
        });
    }

    if (event.target.matches('#pageTareaNueva')) {
        $.each(datos['importanciasOrdenado'], function(key, value) {
            var o = new Option(value['importancia'], value['id']);
            $("#importancia").append(o);
        });
    }
});


document.addEventListener('show', function(event) {
    if (event.target.matches('#pageListaCompra') && haynuevos == true) {
        leerkey('listacompra', pintarDatos);
        haynuevos = false;
    }

    if (event.target.matches('#pageTareas') && haynuevos == true) {
        leerkey('listatareas', pintarTareas);
        haynuevos = false;
    }

    if (event.target.matches('#pageAgenda') && haynuevos == true) {
        leerkey('listaagenda', pintarAgenda);
        haynuevos = false;
    }
});

function leer(fn = nohagona) {
    $.each(datos, function(key, val) {
        $.ajax({
                method: "GET",
                url: "./includes/",
                data: { "tabla": key }
            })
            .done(function(msg) {
                datos[key] = msg;
                fn();
            });
    });
}

function leerkey(key, fn = nohagona) {
    $.ajax({
            method: "GET",
            url: "./includes/",
            data: { "tabla": key }
        })
        .done(function(msg) {
            datos[key] = msg;
            fn();
        });
}


function nuevo(tabla, fn = nohagona) {
    $.each(datos, function(key, val) {
        $.ajax({
                method: "POST",
                url: "./includes/",
                data: { "tabla": key }
            })
            .done(function(msg) {
                datos[key] = msg;
            });
    });
    fn();
}


//actualizar listas, DESLIZABLE
function actualizarListas(fn, id = 'pull-hook') {
    var pullHook = document.getElementById(id);
    var icon = document.getElementById(id + '-icon');
    pullHook.addEventListener('changestate', function(event) {
        switch (event.state) {
            case 'initial':
                icon.setAttribute('icon', 'fa-arrow-down');
                icon.removeAttribute('rotate');
                icon.removeAttribute('spin');
                break;
            case 'preaction':
                icon.setAttribute('icon', 'fa-arrow-down');
                icon.setAttribute('rotate', '180');
                icon.removeAttribute('spin');
                break;
            case 'action':
                icon.setAttribute('icon', 'fa-spinner');
                icon.removeAttribute('rotate');
                icon.setAttribute('spin', true);
                break;
        }
    });

    pullHook.onAction = function(done) {
        setTimeout(done, 250);
        fn(done);
    };
}

//reconocimiento de voz
function reconocerVozBuscar(input, boton = 'botonvoz') {
    if ("speechSynthesis" in window) {
        $("#" + boton).css('background-color', 'green');
        $("#" + boton).html("<ons-icon icon='fa-play'></ons-icon> &nbsp; CAPTURANDO ...");
        const SpeechRecognition = window.SpeechRecognition || window.webkitSpeechRecognition;
        recognition = new SpeechRecognition();
        recognition.continuous = true;
        recognition.start();
        recognition.onresult = function(event) {
            var transcript = event.results[0][0].transcript;
            transcript = transcript[0].toUpperCase() + transcript.slice(1);
            $("#" + input).val("");
            $("#" + input).val(transcript);
            $("#" + input).keyup();
            recognition.stop();
            $("#" + boton).html("<ons-icon icon='fa-microphone'></ons-icon> &nbsp; CAPTURAR AUDIO");
            $("#" + boton).css("background-color", "rgb(30, 136, 229");
        };
    }
}

function getCookie(name) {
    return decodeURIComponent(document.cookie.replace(new RegExp("(?:(?:^|.*;)\\s*" + name.replace(/[\-\.\+\*]/g, "\\$&") + "\\s*\\=\\s*([^;]*).*$)|^.*$"), "$1")) || null;
}

function nohagona() {}