<?php
header('Access-Control-Allow-Origin: *');
header("Access-Control-Allow-Headers: Authorization, X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method,IdUsuario");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE");
header("Allow: GET, POST, OPTIONS, PUT, DELETE");
header("X-Content-Type-Options: nosniff");
$method = $_SERVER['REQUEST_METHOD'];
if ($method == "OPTIONS") {
    die();
}

include_once("./datos.php");
$db = new ddbb('localhost', 'familia', 'host', 'ciberweb69');
$peticion = new apitablas($db);

class apitablas
{
    protected $db;
    protected $tabla;
    protected $metodo;
    protected $tablas = []; //Se necesita añadir el ID Familia
    protected $tablasG = []; //Tablas que se lanzas enteras sin filtrar familias
    protected $tablasC = []; //Tablas virtuales en SQL 

    protected $familia;
    protected $key;


    function __construct($db)
    {
        $this->db = $db;
        $this->tabla = $_GET['tabla'];
        $this->metodo = $_SERVER['REQUEST_METHOD'];
        $this->inicio();
    }

    function inicio()
    {
        $this->familia = $_COOKIE['idfamilia'];
        $this->key = $_COOKIE['keyfamilia'];
        $result = $this->db->mysqli->prepare("select id from familias where id = ? and keyfamilia = ?");
        $result->bind_param('is', $this->familia, $this->key);
        $result->execute();
        $result = $result->get_result();
        if ($result->num_rows == 0 || $_SERVER["HTTP_HOST"] != $_SERVER['SERVER_NAME']) {
            header('HTTP/1.1 401 Unauthorized.');
            exit();
        }
        $this->tablas[0] = ['lista_compra', 'tareas', 'agenda'];
        $this->tablasG[0] = ['categoriasProductosOrdenado', 'importanciasOrdenado', 'avisos_agenda'];
        $this->tablasC['listacompra'] = 'select lista_compra.*, categoriasProductos.categoria as cat from lista_compra, categoriasProductos where lista_compra.familia = ' . $this->familia . ' and lista_compra.categoria = categoriasProductos.id order by categoriasProductos.categoria, lista_compra.producto';
        $this->tablasC['listatareas'] = 'select tareas.*, importancias.importancia as imp, importancias.color from tareas, importancias where tareas.familia = ' . $this->familia . ' and tareas.importancia = importancias.id order by importancias.valor desc, tareas.tarea';
        $this->tablasC['listaagenda'] = 'SELECT agenda.*, count(avisos_agenda.id) as total_avisos, DATE_FORMAT(agenda.fecha, "%W, %d/%M/%Y - %H:%ih") AS fechas FROM agenda LEFT JOIN avisos_agenda on agenda.id = avisos_agenda.agenda GROUP BY avisos_agenda.agenda order by agenda.fecha asc';
        $this->tablasC['insertavisosagendas'] = "OK";
        switch ($this->metodo) {
            case 'GET': //listar
                $this->get();
                //echo $sql;
                break;

            case 'POST': ///crear
                $this->post();
                break;


            case 'PUT': ///modificar
                $this->put();
                break;

            case 'DELETE': ///borrar
                $this->delete();
                break;


            default:
                header('HTTP/1.1 404 Not found.');
                break;
        }
    }

    function get()
    {
        if (in_array($this->tabla, $this->tablas[0]) || in_array($this->tabla, $this->tablasG[0]) || $this->tablasC[$this->tabla] != "") {
            $sql = 'select * from ' . $this->db->limpiar($this->tabla);
            if (in_array($this->tabla, $this->tablas[0])) {
                $sql = 'select * from ' . $this->db->limpiar($this->tabla) . " where familia = " . $this->familia;
            } else if (!empty($this->tablasC[$this->tabla]) && $this->tablasC[$this->tabla] != "") {
                $sql = $this->tablasC[$this->tabla];
            }
            $this->enviarJson($sql);
        } else {
            header('HTTP/1.1 404 Not found.');
            return;
        }
    }
    function post()
    {
        if (in_array($this->tabla, $this->tablas[0]) || in_array($this->tabla, $this->tablasG[0]) || $this->tablasC[$this->tabla] != "") {
            if ($json = json_decode(file_get_contents("php://input"), true)) {
                //print_r($json);

                $campos = "";
                $valores = "";
                $sql = "";

                foreach ($json as $clave => $valor) {
                    $$clave = $this->db->limpiar($valor);
                    $campos .= $this->db->limpiar($clave) . ', ';
                    $valores .= '"' . $this->db->limpiar($valor) . '", ';
                }
                if(in_array($this->tabla, $this->tablas[0])){
                    $campos .=  'familia';
                    $valores .= '"' . $this->familia . '"';
                    $sql = 'INSERT INTO ' . $this->tabla . '(' . $campos . ') VALUES (' . $valores . ')';
                } else if(in_array($this->tabla, $this->tablasG[0])) {
                    $campos = substr($campos, 0, -2);
                    $valores = substr($valores, 0, -2);
                    $sql = 'INSERT INTO ' . $this->tabla . '(' . $campos . ') VALUES (' . $valores . ')';
                } else {
                    switch ($this->tabla) {
                        case 'insertavisosagendas':
                            $sql = "INSERT INTO avisos_agenda (fecha, agenda) VALUES ('".$this->db->limpiar($json['fecha'])."', (SELECT id from agenda where id = " . $this->db->limpiar($json['agenda']) . " and familia = ".$this->familia."))";
                            break;
                        default:
                            break;
                    }
                }
                //echo $sql;
                $id = $this->db->insert($sql);
                if (is_numeric($id) && $id > 0) {
                    header('HTTP/1.1 200 OK.');
                    echo '{"id" : ' . $id . '}';
                } else {
                    header('HTTP/1.1 400 Bad Request.');
                    //Procesamos el erro y en consecuencia enviamos un mensaje
                    $error = $id->error;
                    echo '{"Error": "' . $error . '"}';
                }
            } else {
                header('HTTP/1.1 400 Bad Request.');
                echo '{"Error": "La cadena enviada en el cuerpo de la petición, tiene que ser un JSON válido"}';
            }
        } else {
            header('HTTP/1.1 405 Method Not Allowed.');
        }
    }
    function put()
    {
        if (!empty($_GET['id']) && is_numeric($_GET['id']) && $_GET['id'] > 0 &&  $this->tablas[0] && in_array($this->tabla, $this->tablas[0])) {
            if ($json = json_decode(file_get_contents("php://input"), true)) {
                $set = "";
                foreach ($json as $clave => $valor) {
                    $$clave = $this->db->limpiar($valor);
                    $set .= ' ' . $clave . ' = "' . $valor . '", ';
                }
                $set = substr($set, 0, -2);
                $sql = 'UPDATE ' . $this->tabla . ' SET ' . $set . ' WHERE familia = ' . $this->familia . ' and id = ' . $_GET["id"];
                //echo $sql;
                $this->db->update($sql);
            } else {
                header('HTTP/1.1 409 Conflict.');
            }
        } else {
            header('HTTP/1.1 405 Method Not Allowed.');
        }
    }
    function delete()
    {
        if (in_array($this->tabla, $this->tablas[0])) {
            if ($json = json_decode(file_get_contents("php://input"), true)) {
                $sql = 'delete from ' . $this->db->limpiar($this->tabla) . ' WHERE familia = ' . $this->familia . ' and id = ' . $json["id"];
                $this->db->delete($sql);
            }
        }
        else {
            header('HTTP/1.1 404 Not found.');
        }
    }



    function enviarJson($sql)
    {
        //echo $sql;
        $array = $this->db->select($sql);
        if (count($array) > 0) {
            header('Content-Type: application/json');
            echo json_encode($array);
        } else {
            header('HTTP/1.1 204 No Content.');
        }
    }

    function validarSql($sql)
    {
        $palabras_prohibidas = ['select', 'where', 'insert', 'into', 'values', 'drop', 'show', 'delete', 'update', ';'];
        foreach ($palabras_prohibidas as $key => $value) {
            if (strpos($sql, $value) !== false) {
                return true;
            }
        }
        return false;
    }
}
