<?php
/*
ini_set('error_reporting', E_ALL);
ini_set('display_errors', 'On');
ini_set('display_startup_errors', 'On');
*/

class ddbb
{
    private $hostname;
    private $database;
    private $username;
    private $password;
    var $mysqli;
    private $tablas_logs; //array que contiene los alias para detectar tablas cuyos cambioas van a log

    function __construct($hostname, $database, $username, $password)
    {
        $this->hostname = $hostname;
        $this->database = $database;
        $this->username = $username;
        $this->password = $password;


        $this->mysqli = new mysqli($this->hostname, $this->username, $this->password, $this->database);
        if ($this->mysqli->connect_errno) {
            die("Fallo la conexión a MySQL: (" . $this->mysqli->connect_errno . ") " . $this->mysqli->error);
        } else {
            $this->mysqli->set_charset("utf8");
            setlocale(LC_ALL, 'es_ES.UTF-8');
        }
    }

    function limpiar($texto)
    {
        return $this->mysqli->real_escape_string($texto);
    }


    function select($sql)
    {
        $sqlArray = array();
        $this->mysqli->query("SET lc_time_names = 'es_ES'");
        if ($result = $this->mysqli->query($sql)) {
            while ($sql = $result->fetch_assoc()) {
                $sqlArray[] = $sql;
            }
            return $sqlArray;
        } else {
            echo '{"codigo:"' . $this->mysqli->errno . '", "error":"' . $this->mysqli->error . '"}';
            header('HTTP/1.1 405 Method Not Allowed.');
        }
    }


    function delete($sql)
    {
        if ($this->mysqli->query($sql)) {
            if ($this->mysqli->affected_rows >= 1) {
                header('HTTP/1.1 200 OK.');
            }
        } else {
            echo '{"codigo":"' . $this->mysqli->errno . '", "error":"' . $this->mysqli->error . '"}';
            header('HTTP/1.1 404 Not found.');
        }
    }

    function update($sql)
    {
        if ($this->mysqli->query($sql)) {
            if ($this->mysqli->affected_rows == 1) {
                header('HTTP/1.1 200 OK.');
            }
        } else {
            echo '{"codigo:"' . $this->mysqli->errno . '", "error":"' . $this->mysqli->error . '"}';
            header('HTTP/1.1 405 Method Not Allowed.');
        }
    }

    function insert($sql)
    {
        if ($this->mysqli->query($sql)) {
            if ($this->mysqli->affected_rows == 1) {
                $id = $this->mysqli->insert_id;
                if ($id > 0) {
                    return $id;
                } else {
                    return 0;
                }
            } else {
                echo '{"codigo":"' . $this->mysqli->errno . '", "error":"' . $this->mysqli->error . '"}';
                return $this->mysqli;
            }
        } else {
            echo '{"codigo":"' . $this->mysqli->errno . '", "error":"' . $this->mysqli->error . '"}';
            return $this->mysqli;
        }
    }

    function infoCampos($sql)
    {
        $sqlArray = array();
        if ($result = $this->mysqli->query($sql)) {
            while ($sql = $result->fetch_fields()) {
                $sqlArray[] = $sql;
            }
            return $sqlArray;
        } else {
            header('HTTP/1.1 405 Method Not Allowed.');
        }
    }

    function comprobarRegistro($tabla, $campo, $valor)
    {
        if ($result = $this->mysqli->query('select ' . $this->limpiar($campo) . ' from ' . $this->limpiar($tabla) . ' where ' . $this->limpiar($campo) . ' = "' . $this->limpiar($valor) . '"')) {
            return $result->num_rows;
        } else {
            return 0;
        }
    }

    function guardarLog($tipodocumento, $id, $accion)
    {
        if (!empty($this->tablas_logs[$tipodocumento])) {
            if ($result = $this->mysqli->query('select * from historial_documentos where TipoDocumento = "' . $this->tablas_logs[$tipodocumento] . '" and Id = "' . $id . '" AND DATE_ADD(Fecha,INTERVAL 5 SECOND) > NOW()')) {
                if ($result->num_rows == 0) {
                    $sql = "INSERT INTO historial_documentos (IdUsuario, TipoDocumento, Id, Fecha, Accion) VALUES (" . $GLOBALS["IdDelUsuario"] . ", '" . $this->tablas_logs[$tipodocumento] . "', " . $id .  ", NOW(), '" . $accion . "')";
                    $this->mysqli->query($sql);
                }
            }
        }
    }

    function tipoCampo($tipo)
    {
        switch ($tipo) {
            case 'DECIMAL':
            case 'NEWDECIMAL':
            case 'FLOAT':
            case 'DOUBLE':
                return 'd';

            case 'SHORT':
            case 'INT':
            case 'LONG':
            case 'LONGLONG':
            case 'INT24':
            case 'YEAR':
            case 'ENUM':
            case 'TINYINT':
            case 'SMALLINT':
            case 'MEDIUMINT':
            case 'INT ':
            case 'BIGINT':
            case 'BIT ':
                return 'i';

            case 'CHAR':
            case 'VARCHAR':
            case 'BINARY':
            case 'VARBINARY':
            case 'TINYBLOB':
            case 'BLOB':
            case 'MEDIUMBLOB':
            case 'LONGBLOB':
            case 'TINYTEXT':
            case 'TEXT':
            case 'MEDIUMTEXT':
            case 'LONGTEXT':
            case 'ENUM':
            case 'SET':
                return 's';

            case 'DATE':
            case 'TIME':
            case 'DATETIME':
            case 'TIMESTAMP':
                return 'f';

            default:
                return 's';
        }
    }
}
