function pintarDatos() {
    var listado = $("#pageListaCompra #listadolistacompra");
    listado.html("");
    listados = [];
    contador = 0;
    if (datos['listacompra'].length > 0) {
        $.each(datos['listacompra'], function(key, value) {
            var checked = 'checked';
            if (value['estado'] == 1) {
                checked = '';
            }

            if ((categoriaProductosFiltro == -1 || value['categoria'] == categoriaProductosFiltro) && (estadoProductosFiltro == value['estado'])) {
                listados[key] = '<ons-list-item id="producto_' + value['id'] + '" data-key="' + key + '"><div class="left"><ons-checkbox ' + checked + ' onchange="estadoProducto(' + value['id'] + ')" input-id="check-' + value['id'] + '"></ons-checkbox></div><div data-key="' + key + '" class="center color' + value['estado'] + '"><span class="list-item__title">' + value['producto'] + '</span><span class="list-item__subtitle">' + value['cat'] + '</span></div><div class="right" onclick="BorrarProducto(' + value['id'] + ')"><ons-icon icon="fa-trash-alt"></ons-icon></div></ons-list-item>';
                contador++;
            }
        });
        if (contador == 0) {
            listados[0] = '<ons-list-item><div class="left"><ons-icon icon="fa-exclamation-circle" style="color:red" class="list-item__icon"></ons-icon></div><div class="center"> No hay productos...</div></ons-list-item>';
        }
        if (listados.length > 0) {
            $.each(listados, function(key, val) {
                listado.append(val);
            });
        }
    } else {
        $.each(listados, function(key, val) {
            listado.append(val);
        });
    }

    $("#pageListaCompra #listadolistacompra .center").click(function(e) {
        key_p = $(this).data("key");
        id_p = datos['listacompra'][key_p]['id'];
        myNavigator.pushPage('editarproducto.html')
    });
}

function NuevoProducto() {
    $("#iconobotonguardar").html('<ons-icon spin icon="fa-spinner"></ons-icon>');
    let producto = $("#pageListaCompraNuevo #producto").val();
    if (producto != "") {
        $.ajax({
                method: "POST",
                url: "./includes/?tabla=lista_compra",
                dataType: 'json',
                data: JSON.stringify({ "producto": producto, "categoria": $("#categorias").val(), "estado": 1 })
            })
            .done(function(msg) {
                $("#iconobotonguardar").html('<ons-icon icon="fa-save"></ons-icon>');
                if (msg['id'] >= 0) {
                    haynuevos = true;
                    $("#listadolistacompranuevo").prepend('<ons-list-item><div class="center"><span class="list-item__title">' + $("#producto").val() + '</span><span class="list-item__subtitle">' + $("#categorias option:selected").html() + '</span></div></ons-list-item>');
                    $("#pageListaCompraNuevo #producto").val("");
                    ons.notification.toast('<ons-icon style="color: green;" icon="fa-check"></ons-icon> Producto guardado correctamente<button onclick="mitoast.hide()">Cerrar</button>', {
                        id: "mitoast",
                        timeout: 1000
                    });
                } else {
                    ons.notification.toast('<ons-icon style="color: red;" icon="fa-exclamation-triangle"></ons-icon> ERROR, algo ha fallado <button onclick="mitoast.hide()">Cerrar</button>', {
                        id: "mitoast",
                        timeout: 2000
                    });
                }
            });
    }
}


function BorrarProducto(id) {
    if (id >= 0) {
        $.ajax({
            method: "DELETE",
            url: "./includes/?tabla=lista_compra",
            dataType: 'json',
            data: JSON.stringify({ "id": id }),
            complete: function(xhr, textStatus) {
                if (xhr.status == 200) {
                    let key = $("#producto_" + id).data("key");
                    datos['listacompra'].splice(key, 1);
                    $("#producto_" + id).hide('slow', function() {
                        pintarDatos();
                    });
                    ons.notification.toast('<ons-icon style="color: green;" icon="fa-check"></ons-icon> Producto Eliminado correctamente<button onclick="mitoast.hide()">Cerrar</button>', {
                        id: "mitoast",
                        timeout: 1000
                    });
                } else {
                    ons.notification.toast('<ons-icon style="color: red;" icon="fa-exclamation-triangle"></ons-icon> ERROR, algo ha fallado <button onclick="mitoast.hide()">Cerrar</button>', {
                        id: "mitoast",
                        timeout: 3000
                    });
                }

            }
        })
    }
}

function estadoProducto(id) {
    if (id >= 0) {
        var estadoviejo = 1;
        var estado = 0;
        if ($('#check-' + id).prop('checked') == false) {
            estado = 1;
            estadoviejo = 0;
        }

        $.ajax({
            method: "PUT",
            url: "./includes/?tabla=lista_compra&id=" + id,
            dataType: 'json',
            data: JSON.stringify({ "estado": estado }),
            complete: function(xhr, textStatus) {
                if (xhr.status == 200) {
                    let key = $("#producto_" + id).data("key");
                    datos['listacompra'][key]['estado'] = estado;
                    $("#producto_" + id + " .center").removeClass("color" + estadoviejo).addClass("color" + estado);
                    ons.notification.toast('<ons-icon style="color: green;" icon="fa-check"></ons-icon> Operación guarda correctamente<button onclick="mitoast.hide()">Cerrar</button>', {
                        id: "mitoast",
                        timeout: 1000
                    });
                } else {
                    ons.notification.toast('<ons-icon style="color: red;" icon="fa-exclamation-triangle"></ons-icon> ERROR, algo ha fallado <button onclick="mitoast.hide()">Cerrar</button>', {
                        id: "mitoast",
                        timeout: 3000
                    });
                }

            }
        })
    }
}

function EditarProducto() {
    if (id_p >= 0) {
        $.ajax({
            method: "PUT",
            url: "./includes/?tabla=lista_compra&id=" + id_p,
            dataType: 'json',
            data: JSON.stringify({ "estado": $("#estado").val(), "producto": $("#producto").val(), "categoria": $("#categorias").val() }),
            complete: function(xhr, textStatus) {
                if (xhr.status == 200) {
                    datos['listacompra'][key_p]['estado'] = $("#estado").val();
                    datos['listacompra'][key_p]['categoria'] = $("#categorias").val();
                    datos['listacompra'][key_p]['producto'] = $("#producto").val();
                    datos['listacompra'][key_p]['cat'] = $("#categorias option:selected").html();
                    pintarDatos();
                    ons.notification.toast('<ons-icon style="color: green;" icon="fa-check"></ons-icon> Operación guarda correctamente<button onclick="mitoast.hide()">Cerrar</button>', {
                        id: "mitoast",
                        timeout: 1000
                    });
                } else {
                    ons.notification.toast('<ons-icon style="color: red;" icon="fa-exclamation-triangle"></ons-icon> ERROR, algo ha fallado <button onclick="mitoast.hide()">Cerrar</button>', {
                        id: "mitoast",
                        timeout: 3000
                    });
                }

            }
        })
    }
}