function pintarAgenda() {
    var listado = $("#pageAgenda #listado");
    listado.html("");
    listados = [];
    contador = 0;
    if (datos['listaagenda'].length > 0) {
        $.each(datos['listaagenda'], function(key, value) {
            listados[key] = '<ons-list-item id="agenda_' + value['id'] + '" data-key="' + key + '"><div class="left">';
            if (value['total_avisos'] > 0) {
                listados[key] += '<ons-icon icon="fa-bell"></ons-icon>';
            } else {
                listados[key] += '<ons-icon style="color:grey" icon="fa-bell-slash"></ons-icon>';
            }
            listados[key] += '</div><div data-key="' + key + '" class="center"><span class="list-item__title">' + value['texto'] + '</span><span class="list-item__subtitle">' + value['fechas'] + '</span></div><div class="right" onclick="showPopover(this);"><ons-icon icon="fa-trash-alt"></ons-icon></div></ons-list-item>';
            contador++;
        });
        if (contador == 0) {
            listados[0] = '<ons-list-item><div class="left"><ons-icon icon="fa-exclamation-circle" style="color:red" class="list-item__icon"></ons-icon></div><div class="center"> No hay Tareas...</div></ons-list-item>';
        }
        if (listados.length > 0) {
            $.each(listados, function(key, val) {
                listado.append(val);
            });
        }
    } else {
        $.each(listados, function(key, val) {
            listado.append(val);
        });
    }

    $("#pageAgenda #listado .center").click(function(e) {
        key_p = $(this).data("key");
        id_p = datos['listaagenda'][key_p]['id'];
        myNavigator.pushPage('editaragenda.html')
    });
}

function NuevaAgenda() {
    $("#iconobotonguardar").html('<ons-icon spin icon="fa-spinner"></ons-icon>');
    let texto = $("#pageAgendaNueva #texto").val();
    if (texto != "") {
        $.ajax({
                method: "POST",
                url: "./includes/?tabla=agenda",
                dataType: 'json',
                data: JSON.stringify({ "texto": texto, "fecha": $("#fecha").val() })
            })
            .done(function(msg) {
                $("#iconobotonguardar").html('<ons-icon icon="fa-save"></ons-icon>');
                if (msg['id'] >= 0) {
                    haynuevos = true;
                    //$("#listadonuevos").prepend('<ons-list-item><div class="center"><span class="list-item__title">' + $("#texto").val() + '</span><span class="list-item__subtitle">' + $("#fecha").val() + '</span></div></ons-list-item>');
                    $("#pageAgendaNueva #texto").val("");
                    $("#pageAgendaNueva #fecha").val("");
                    for (let i = 1; i < 5; i++) {
                        if ($("#aviso_" + i).val() != "") {
                            $.ajax({
                                type: "POST",
                                url: "./includes/?tabla=insertavisosagendas",
                                data: JSON.stringify({ "fecha": $("#aviso_" + i).val(), "agenda": msg['id'] }),
                                dataType: "json",
                                success: function(response) {
                                    $("#aviso_" + i).val("");
                                }
                            });
                        }
                    }
                    ons.notification.toast('<ons-icon style="color: green;" icon="fa-check"></ons-icon> Agendado Guardada Correctamente<button onclick="mitoast.hide()">Cerrar</button>', {
                        id: "mitoast",
                        timeout: 1000
                    });
                } else {
                    ons.notification.toast('<ons-icon style="color: red;" icon="fa-exclamation-triangle"></ons-icon> ERROR, algo ha fallado <button onclick="mitoast.hide()">Cerrar</button>', {
                        id: "mitoast",
                        timeout: 2000
                    });
                }
            });
    }
}

function BorrarAgenda(id) {
    if (id >= 0) {
        $.ajax({
            method: "DELETE",
            url: "./includes/?tabla=agenda",
            dataType: 'json',
            data: JSON.stringify({ "id": id }),
            complete: function(xhr, textStatus) {
                if (xhr.status == 200) {
                    let key = $("#agenda_" + id).data("key");
                    datos['listaagenda'].splice(key, 1);
                    $("#agenda_" + id).hide('slow', function() {
                        pintarAgenda();
                    });
                    ons.notification.toast('<ons-icon style="color: green;" icon="fa-check"></ons-icon> Agendado Eliminado Correctamente<button onclick="mitoast.hide()">Cerrar</button>', {
                        id: "mitoast",
                        timeout: 1000
                    });
                } else {
                    ons.notification.toast('<ons-icon style="color: red;" icon="fa-exclamation-triangle"></ons-icon> ERROR, algo ha fallado <button onclick="mitoast.hide()">Cerrar</button>', {
                        id: "mitoast",
                        timeout: 3000
                    });
                }
            }
        })
    }
}

function EditarAgenda() {
    if (id_p >= 0) {
        $.ajax({
            method: "PUT",
            url: "./includes/?tabla=tareas&id=" + id_p,
            dataType: 'json',
            data: JSON.stringify({ "tarea": $("#tarea").val(), "importancia": $("#importancia").val() }),
            complete: function(xhr, textStatus) {
                if (xhr.status == 200) {
                    datos['listatareas'][key_p]['tarea'] = $("#tarea").val();
                    datos['listatareas'][key_p]['importancia'] = $("#importancia").val();
                    datos['listatareas'][key_p]['imp'] = $("#importancia option:selected").html();
                    var importancia = datos['importanciasOrdenado'].filter(function(el) {
                        return el.id == $("#importancia").val();
                    });
                    datos['listatareas'][key_p]['color'] = importancia[0]['color'];
                    pintarTareas();
                    ons.notification.toast('<ons-icon style="color: green;" icon="fa-check"></ons-icon> Tarea Editada Correctamente<button onclick="mitoast.hide()">Cerrar</button>', {
                        id: "mitoast",
                        timeout: 1000
                    });
                } else {
                    ons.notification.toast('<ons-icon style="color: red;" icon="fa-exclamation-triangle"></ons-icon> ERROR, algo ha fallado <button onclick="mitoast.hide()">Cerrar</button>', {
                        id: "mitoast",
                        timeout: 3000
                    });
                }

            }
        })
    }
}